/* German translation for the jQuery Timepicker Addon */
/* Written by Marvin */
(function($) {
	$.timepicker.regional['de'] = {
		timeOnlyTitle: 'Zeit Wählen',
		timeText: 'Zeit',
		hourText: 'Stunde',
		minuteText: 'Minute',
		secondText: 'Sekunde',
		millisecText: 'Millisekunde',
		microsecText: 'Mikrosekunde',
		timezoneText: 'Zeitzone',
		currentText: 'Jetzt',
		closeText: 'Fertig',
		timeFormat: 'HH:mm',
		amNames: ['vorm.', 'AM', 'A'],
		pmNames: ['nachm.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* French translation for the jQuery Timepicker Addon */
/* Written by Thomas Lété */
(function($) {
	$.timepicker.regional['fr'] = {
		timeOnlyTitle: 'Choisir une heure',
		timeText: 'Heure',
		hourText: 'Heures',
		minuteText: 'Minutes',
		secondText: 'Secondes',
		millisecText: 'Millisecondes',
		microsecText: 'Microsecondes',
		timezoneText: 'Fuseau horaire',
		currentText: 'Maintenant',
		closeText: 'Terminé',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Russian translation for the jQuery Timepicker Addon */
/* Written by Trent Richardson */
(function($) {
	$.timepicker.regional['ru'] = {
		timeOnlyTitle: 'Выберите время',
		timeText: 'Время',
		hourText: 'Часы',
		minuteText: 'Минуты',
		secondText: 'Секунды',
		millisecText: 'Миллисекунды',
		microsecText: 'Микросекунды',
		timezoneText: 'Часовой пояс',
		currentText: 'Сейчас',
		closeText: 'Закрыть',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Estonian translation for the jQuery Timepicker Addon */
/* Written by Karl Sutt (karl@sutt.ee) */
(function($) {
	$.timepicker.regional['et'] = {
		timeOnlyTitle: 'Vali aeg',
		timeText: 'Aeg',
		hourText: 'Tund',
		minuteText: 'Minut',
		secondText: 'Sekund',
		millisecText: 'Millisekundis',
		microsecText: 'Mikrosekundis',
		timezoneText: 'Ajavöönd',
		currentText: 'Praegu',
		closeText: 'Valmis',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Brazilian Portuguese translation for the jQuery Timepicker Addon */
/* Written by Diogo Damiani (diogodamiani@gmail.com) */
(function ($) {
	$.timepicker.regional['pt'] = {
		timeOnlyTitle: 'Escolha o horário',
		timeText: 'Horário',
		hourText: 'Hora',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milissegundos',
		microsecText: 'Microssegundos',
		timezoneText: 'Fuso horário',
		currentText: 'Agora',
		closeText: 'Fechar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Polish translation for the jQuery Timepicker Addon */
/* Written by Michał Pena */
(function($) {
	$.timepicker.regional['pl'] = {
		timeOnlyTitle: 'Wybierz godzinę',
		timeText: 'Czas',
		hourText: 'Godzina',
		minuteText: 'Minuta',
		secondText: 'Sekunda',
		millisecText: 'Milisekunda',
		microsecText: 'Mikrosekunda',
		timezoneText: 'Strefa czasowa',
		currentText: 'Teraz',
		closeText: 'Gotowe',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Italian translation for the jQuery Timepicker Addon */
/* Written by Marco "logicoder" Del Tongo */
(function($) {
    $.timepicker.regional['it'] = {
        timeOnlyTitle: 'Scegli orario',
        timeText: 'Orario',
        hourText: 'Ora',
        minuteText: 'Minuti',
        secondText: 'Secondi',
        millisecText: 'Millisecondi',
        microsecText: 'Microsecondi',
        timezoneText: 'Fuso orario',
        currentText: 'Adesso',
        closeText: 'Chiudi',
        timeFormat: 'HH:mm',
        amNames: ['m.', 'AM', 'A'],
        pmNames: ['p.', 'PM', 'P'],
        isRTL: false
    };
})(jQuery);

/* Dutch translation for the jQuery Timepicker Addon */
/* Written by Martijn van der Lee */
(function($) {
	$.timepicker.regional['nl'] = {
		timeOnlyTitle: 'Tijdstip',
		timeText: 'Tijd',
		hourText: 'Uur',
		minuteText: 'Minuut',
		secondText: 'Seconde',
		millisecText: 'Milliseconde',
		microsecText: 'Microseconde',
		timezoneText: 'Tijdzone',
		currentText: 'Vandaag',
		closeText: 'Sluiten',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

(function($) {
	$.timepicker.regional['es'] = {
		timeOnlyTitle: 'Elegir una hora',
		timeText: 'Hora',
		hourText: 'Horas',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milisegundos',
		microsecText: 'Microsegundos',
		timezoneText: 'Huso horario',
		currentText: 'Ahora',
		closeText: 'Cerrar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

(function($) {
	$.timepicker.regional['sv'] = {
		timeOnlyTitle: 'Välj en tid',
		timeText: 'Tid',
		hourText: 'Timme',
		minuteText: 'Minut',
		secondText: 'Sekund',
		millisecText: 'Millisekund',
		microsecText: 'Mikrosekund',
		timezoneText: 'Tidszon',
		currentText: 'Nu',
		closeText: 'Stäng',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Finnish translation for the jQuery Timepicker Addon */
/* Written by Juga Paazmaya (http://github.com/paazmaya) */
(function($) {
	$.timepicker.regional['fi'] = {
		timeOnlyTitle: 'Valitse aika',
		timeText: 'Aika',
		hourText: 'Tunti',
		minuteText: 'Minuutti',
		secondText: 'Sekunti',
		millisecText: 'Millisekunnin',
		microsecText: 'Mikrosekuntia',
		timezoneText: 'Aikavyöhyke',
		currentText: 'Nyt',
		closeText: 'Sulje',
		timeFormat: 'HH:mm',
		amNames: ['ap.', 'AM', 'A'],
		pmNames: ['ip.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Danish translation for the jQuery Timepicker Addon */
/* Written by Lars H. Jensen (http://www.larshj.dk) */
(function ($) {
    $.timepicker.regional['da'] = {
        timeOnlyTitle: 'Vælg tid',
        timeText: 'Tid',
        hourText: 'Time',
        minuteText: 'Minut',
        secondText: 'Sekund',
        millisecText: 'Millisekund',
        microsecText: 'Mikrosekund',
        timezoneText: 'Tidszone',
        currentText: 'Nu',
        closeText: 'Luk',
        timeFormat: 'HH:mm',
        amNames: ['am', 'AM', 'A'],
        pmNames: ['pm', 'PM', 'P'],
        isRTL: false
    };
})(jQuery);

/* German translation for the jQuery Timepicker Addon */
/* Written by Marvin */
(function($) {
	$.timepicker.regional['de'] = {
		timeOnlyTitle: 'Zeit Wählen',
		timeText: 'Zeit',
		hourText: 'Stunde',
		minuteText: 'Minute',
		secondText: 'Sekunde',
		millisecText: 'Millisekunde',
		microsecText: 'Mikrosekunde',
		timezoneText: 'Zeitzone',
		currentText: 'Jetzt',
		closeText: 'Fertig',
		timeFormat: 'HH:mm',
		amNames: ['vorm.', 'AM', 'A'],
		pmNames: ['nachm.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Hebrew translation for the jQuery Timepicker Addon */
/* Written by Lior Lapid */
(function($) {
	$.timepicker.regional["he"] = {
		timeOnlyTitle: "בחירת זמן",
		timeText: "שעה",
		hourText: "שעות",
		minuteText: "דקות",
		secondText: "שניות",
		millisecText: "אלפית השנייה",
		microsecText: "מיקרו",
		timezoneText: "אזור זמן",
		currentText: "עכשיו",
		closeText:"סגור",
		timeFormat: "HH:mm",
		amNames: ['לפנה"צ', 'AM', 'A'],
		pmNames: ['אחה"צ', 'PM', 'P'],
		isRTL: true
	};
})(jQuery);

/* Japanese translation for the jQuery Timepicker Addon */
/* Written by Jun Omae */
(function($) {
	$.timepicker.regional['ja'] = {
		timeOnlyTitle: '時間を選択',
		timeText: '時間',
		hourText: '時',
		minuteText: '分',
		secondText: '秒',
		millisecText: 'ミリ秒',
		microsecText: 'マイクロ秒',
		timezoneText: 'タイムゾーン',
		currentText: '現時刻',
		closeText: '閉じる',
		timeFormat: 'HH:mm',
		amNames: ['午前', 'AM', 'A'],
		pmNames: ['午後', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);


/* Turkish initialisation for the jQuery time picker plugin. */
/* Written by Mutlu Tevfik Koçak (mtkocak@gmail.com) */
(function($) {
    $.timepicker.regional['tr'] = {
                hourText: 'Saat',
                minuteText: 'Dakika',
                amPmText: ['AM', 'PM'],
                closeButtonText: 'Kapat',
                nowButtonText: 'Şu anda',
                deselectButtonText: 'Seçimi temizle' };
})(jQuery);


/* Czech translation for the jQuery Timepicker Addon */
/* Written by Ondřej Vodáček */
(function($) {
	$.timepicker.regional['cs'] = {
		timeOnlyTitle: 'Vyberte čas',
		timeText: 'Čas',
		hourText: 'Hodiny',
		minuteText: 'Minuty',
		secondText: 'Vteřiny',
		millisecText: 'Milisekundy',
		microsecText: 'Mikrosekundy',
		timezoneText: 'Časové pásmo',
		currentText: 'Nyní',
		closeText: 'Zavřít',
		timeFormat: 'HH:mm',
		timeSuffix: '',
		amNames: ['dop.', 'AM', 'A'],
		pmNames: ['odp.', 'PM', 'P'],
		isRTL: false
	};
})(jQuery);

/* Hungarian initialisation for the timepicker plugin */
/* Written by Bálint Dávid Tarcsa. */
jQuery(function($){
    $.timepicker.regional['hu'] = {
                hourText: 'Óra',
                minuteText: 'Perc',
                amPmText: ['De.', 'Du.'] ,
                closeButtonText: 'Kész',
                nowButtonText: 'Most',
                deselectButtonText: 'Törlés' }
    $.timepicker.setDefaults($.timepicker.regional['hu']);
});

(function($) {
    $.timepicker.regional['nb'] = {
        timeOnlyTitle: 'Velg tid',
        timeText: 'Tid',
        hourText: 'Time',
        minuteText: 'Minutt',
        secondText: 'Sekund',
        millisecText: 'Millisekund',
        timezoneText: 'Tidssone',
        currentText: 'Nå',
        closeText: 'Lukk',
        timeFormat: 'hh:mm',
        amNames: ['am', 'AM', 'A'],
        pmNames: ['pm', 'PM', 'P'],
        ampm: false
    };
    $.timepicker.setDefaults($.timepicker.regional['nb']);
})(jQuery);

/* Slovak translation for the jQuery Timepicker Addon */
/* Written by David Vallner */
(function($) {
	$.timepicker.regional['sk'] = {
		timeOnlyTitle: 'Zvoľte čas',
		timeText: 'Čas',
		hourText: 'Hodiny',
		minuteText: 'Minúty',
		secondText: 'Sekundy',
		millisecText: 'Milisekundy',
		microsecText: 'Mikrosekundy',
		timezoneText: 'Časové pásmo',
		currentText: 'Teraz',
		closeText: 'Zavrieť',
		timeFormat: 'H:m',
		timeSuffix: '',
		amNames: ['dop.', 'AM', 'A'],
		pmNames: ['pop.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['sk']);
})(jQuery);